#!/bin/sh
set -e

SCRIPTPATH="$( cd "$(dirname "$0")" ; pwd -P )"
for filepath in `find $SCRIPTPATH/.. -type f -or -type l | grep -v "\.\./install/"`; do
    destpath=${filepath##$SCRIPTPATH/..}
    mkdir -p $(dirname "$destpath")
    cp -r "$filepath" "$destpath"
done
set -e
# set -x

PROGRAM=clickhouse-server
CLICKHOUSE_USER=${CLICKHOUSE_USER:-clickhouse}
CLICKHOUSE_GROUP=${CLICKHOUSE_GROUP:-${CLICKHOUSE_USER}}
# Please note that we don't support paths with whitespaces. This is rather ignorant.
CLICKHOUSE_CONFDIR=${CLICKHOUSE_CONFDIR:-/etc/clickhouse-server}
CLICKHOUSE_DATADIR=${CLICKHOUSE_DATADIR:-/var/lib/clickhouse}
CLICKHOUSE_LOGDIR=${CLICKHOUSE_LOGDIR:-/var/log/clickhouse-server}
CLICKHOUSE_BINDIR=${CLICKHOUSE_BINDIR:-/usr/bin}
CLICKHOUSE_GENERIC_PROGRAM=${CLICKHOUSE_GENERIC_PROGRAM:-clickhouse}
CLICKHOUSE_PIDDIR=/var/run/$PROGRAM

# Provide clickhouse-keeper
KEEPER_CONFDIR=${KEEPER_CONFDIR:-/etc/clickhouse-keeper}
KEEPER_DATADIR=${KEEPER_DATADIR:-/var/lib/clickhouse}
KEEPER_LOGDIR=${KEEPER_LOGDIR:-/var/log/clickhouse-keeper}

[ -f /etc/default/clickhouse ] && . /etc/default/clickhouse

if [ ! -f "/etc/debian_version" ]; then
    not_deb_os=1
fi

if [ "$1" = configure ] || [ -n "$not_deb_os" ]; then

    ${CLICKHOUSE_GENERIC_PROGRAM} install --user "${CLICKHOUSE_USER}" --group "${CLICKHOUSE_GROUP}" --pid-path "${CLICKHOUSE_PIDDIR}" --config-path "${CLICKHOUSE_CONFDIR}" --binary-path "${CLICKHOUSE_BINDIR}" --log-path "${CLICKHOUSE_LOGDIR}" --data-path "${CLICKHOUSE_DATADIR}"

    if [ -x "/bin/systemctl" ] && [ -f /lib/systemd/system/clickhouse-server.service ] && [ -d /run/systemd/system ]; then
        # if old rc.d service present - remove it
        if [ -x "/etc/init.d/clickhouse-server" ] && [ -x "/usr/sbin/update-rc.d" ]; then
            /usr/sbin/update-rc.d clickhouse-server remove
        fi

        /bin/systemctl daemon-reload
        /bin/systemctl enable clickhouse-server
    else
        # If you downgrading to version older than 1.1.54336 run: systemctl disable clickhouse-server
        if [ -x "/etc/init.d/clickhouse-server" ]; then
            if [ -x "/usr/sbin/update-rc.d" ]; then
                /usr/sbin/update-rc.d clickhouse-server defaults 19 19 >/dev/null || exit $?
            else
                echo # Other OS
            fi
        fi
    fi

    # Setup clickhouse-keeper directories
    chown -R "${CLICKHOUSE_USER}:${CLICKHOUSE_GROUP}" "${KEEPER_CONFDIR}"
    chmod 0755 "${KEEPER_CONFDIR}"

    if ! [ -d "${KEEPER_DATADIR}" ]; then
        mkdir -p "${KEEPER_DATADIR}"
        chown -R "${CLICKHOUSE_USER}:${CLICKHOUSE_GROUP}" "${KEEPER_DATADIR}"
        chmod 0700 "${KEEPER_DATADIR}"
    fi

    if ! [ -d "${KEEPER_LOGDIR}" ]; then
        mkdir -p "${KEEPER_LOGDIR}"
        chown -R "${CLICKHOUSE_USER}:${CLICKHOUSE_GROUP}" "${KEEPER_LOGDIR}"
        chmod 0770 "${KEEPER_LOGDIR}"
    fi
fi
